<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Antecedent extends Eloquent {

	protected $table = 'antecendents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function patient_backgrounds()
	{
		return $this->hasMany('PatientBackground');
	}

	public function diagnostics()
	{
		return $this->hasMany('Diagnostic');
	}

}