<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Patient extends Eloquent {

	protected $table = 'patients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function scenarios()
	{
		return $this->hasMany('Scenario');
	}

	public function avatar()
	{
		return $this->belongsTo('Avatar');
	}

	public function personal_situation()
	{
		return $this->belongsTo('PersonalSituation');
	}

	public function patient_backgrounds()
	{
		return $this->hasMany('PatientBackground');
	}

	public function drug_therapies()
	{
		return $this->hasMany('DrugTherapy');
	}

	public function non_drug_therapies()
	{
		return $this->hasMany('NonDrugTherapy');
	}

	public function complementary_exams()
	{
		return $this->hasMany('ComplementaryExam');
	}

	public function follow_ups()
	{
		return $this->hasMany('FollowUp');
	}

	public function exam_results()
	{
		return $this->hasMany('ExamResult');
	}

	public function clinical_signs()
	{
		return $this->hasMany('ClinicalSign');
	}

}