<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PatientBackground extends Eloquent {

	protected $table = 'patient_backgrounds';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function patient()
	{
		return $this->belongsTo('Patient');
	}

	public function antecedent()
	{
		return $this->belongsTo('Antecedent');
	}

	public function custom_questions()
	{
		return $this->hasMany('CustomQuestion');
	}

}