<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Scenario extends Model 
{

    protected $table = 'scenarios';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contents()
    {
        return $this->morphMany('Content');
    }

    public function environment()
    {
        return $this->belongsTo('Environment');
    }

    public function patient()
    {
        return $this->belongsTo('Patient');
    }

    public function diagnostics()
    {
        return $this->hasMany('Diagnostic');
    }

    public function patient_questions()
    {
        return $this->hasMany('PatientQuestion');
    }

}