<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClinicalSign extends Model 
{

    protected $table = 'clinical_signs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function patient()
    {
        return $this->belongsTo('Patient');
    }

    public function question_overrides()
    {
        return $this->hasMany('QuestionOverride');
    }

    public function physical_exam_overrides()
    {
        return $this->hasMany('PhysicalExamOverride');
    }

}