<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentsTable extends Migration {

	public function up()
	{
		Schema::create('contents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 256);
			$table->text('description');
			$table->string('image', 256);
			$table->bigInteger('accesscategory_id');
			$table->bigInteger('accesslevel_id');
			$table->enum('level_difficulty', array(''));
			$table->enum('sublevel_difficulty', array(''));
			$table->bigInteger('contentable_id');
			$table->string('contentable_type', 256);
			$table->enum('status', array(''));
			$table->integer('quality_evaluation');
			$table->bigInteger('created_by_user_id');
			$table->bigInteger('updated_by_user_id');
			$table->bigInteger('deleted_by_user_id');
		});
	}

	public function down()
	{
		Schema::drop('contents');
	}
}