<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateToxicDrugsTable extends Migration {

	public function up()
	{
		Schema::create('toxic_drugs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('personal_situation_id');
			$table->bigInteger('type_index');
			$table->string('medecine_type', 256);
			$table->string('medecine_subtype', 256);
			$table->date('last_use_date');
			$table->bigInteger('quitting_attempt_number');
			$table->bigInteger('last_quitting_duration_in_days');
			$table->bigInteger('frequency_index');
		});
	}

	public function down()
	{
		Schema::drop('toxic_drugs');
	}
}