<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDigGeneralTable extends Migration {

	public function up()
	{
		Schema::create('dig_general', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('anio')->index();
			$table->string('nro_orden', 100);
			$table->string('observacion', 150);
			$table->integer('deroga_a')->unsigned();
			$table->text('contenido');
			$table->text('modifica')->nullable();
			$table->integer('created_by');
			$table->integer('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('dig_general');
	}
}