<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('dig_general', function(Blueprint $table) {
			$table->foreign('deroga_a')->references('id')->on('dig_general')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('archivo_digesto', function(Blueprint $table) {
			$table->foreign('id_dig_general')->references('id')->on('dig_general')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tema_digesto', function(Blueprint $table) {
			$table->foreign('id_tema')->references('id')->on('tema')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tema_digesto', function(Blueprint $table) {
			$table->foreign('id_dig_general')->references('id')->on('dig_general')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('dig_general', function(Blueprint $table) {
			$table->dropForeign('dig_general_deroga_a_foreign');
		});
		Schema::table('archivo_digesto', function(Blueprint $table) {
			$table->dropForeign('archivo_digesto_id_dig_general_foreign');
		});
		Schema::table('tema_digesto', function(Blueprint $table) {
			$table->dropForeign('tema_digesto_id_tema_foreign');
		});
		Schema::table('tema_digesto', function(Blueprint $table) {
			$table->dropForeign('tema_digesto_id_dig_general_foreign');
		});
	}
}