<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Archivo extends Eloquent {

	protected $table = 'archivo_digesto';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('url');
	protected $visible = array('url');

	public function digesto()
	{
		return $this->belongsTo('App\Models\Digesto', 'id_dig_general');
	}

}