<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillsTable extends Migration {

	public function up()
	{
		Schema::create('bills', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('status', array('pending', 'failed', 'success'));
			$table->date('next_retry_date')->nullable();
			$table->integer('retry_amount');
			$table->string('invoice_number', 255);
			$table->string('transaction_id', 255)->nullable();
			$table->integer('amount_due_cents');
			$table->integer('billing_details_id')->unsigned();
			$table->integer('subscription_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bills');
	}
}