<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeadsTable extends Migration {

	public function up()
	{
		Schema::create('leads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('quote_id')->unsigned();
			$table->integer('service_profile_id')->unsigned();
			$table->boolean('accepted_by_service_profile');
			$table->boolean('has_service_profile_sent_quote');
			$table->enum('users_response', array('pending', 'approved', 'rejected'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('leads');
	}
}