<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('client_invitations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_profile_id')->unsigned();
			$table->integer('existing_user_id')->unsigned();
			$table->integer('created_active_service_id')->unsigned()->nullable();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->enum('status', array('pending', 'accepted', 'rejected'));
			$table->datetime('date_of_status_update');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('client_invitations');
	}
}