<?php

namespace Snapfile\Entities\Shared;

class ActiveService extends Eloquent {

	protected $table = 'active_service';
	public $timestamps = true;
	protected $fillable = array('client_id', 'client_user_profile_id', 'approved_lead_id');
	protected $visible = array('client_id', 'client_user_profile_id', 'approved_lead_id');

	public function fileShares()
	{
		return $this->hasMany('Snapfile\Entities\FileShare', 'shared_with_active_service_id');
	}

	public function clientInvitationWhichCreatedThis()
	{
		return $this->hasOne('Snapfile\Entities\Shared\ClientInvitation', 'created_active_service_id');
	}

	public function clientUserProfile()
	{
		return $this->belongsTo('Snapfile\Entities\User\Profile', 'client_user_profile_id');
	}

	public function fileRequests()
	{
		return $this->hasMany('Snapfile\Entities\Shared\FileRequest', 'active_service_id');
	}

	public function approvedLead()
	{
		return $this->belongsTo('Snapfile\Entities\Shared\Lead', 'approved_lead_id');
	}

}