<?php

namespace Snapfile\Entities\Billing;

class Bill extends Eloquent {

	protected $table = 'bills';
	public $timestamps = true;
	protected $fillable = array('billing_details_id', 'subscription_id');
	protected $visible = array('status', 'next_retry_date', 'retry_amount', 'invoice_number', 'transaction_id', 'amount_due_cents', 'billing_details_id', 'subscription_id');

	public function billingDetails()
	{
		return $this->belongsTo('Snapfile\Entities\Billing\BillingDetails', 'billing_details_id');
	}

	public function subscription()
	{
		return $this->belongsTo('Snapfile\Entities\Billing\Subscription', 'subscription_id');
	}

}