<?php

namespace Snapfile\Entities\Business;

class BusinessProfile extends Eloquent {

	protected $table = 'business_profiles';
	public $timestamps = true;
	protected $fillable = array('administrator_user_id', 'name', 'email', 'phone_number', 'abn');
	protected $visible = array('administrator_user_id', 'name', 'email', 'phone_number', 'abn', 'verified');

	public function adminUser()
	{
		return $this->belongsTo('Snapfile\Entities\User\User', 'administrator_user_id');
	}

	public function serviceProfiles()
	{
		return $this->hasMany('Snapfile\Entities\Business\ServiceProfile', 'business_profile_id');
	}

	public function billingDetails()
	{
		return $this->hasOne('Snapfile\Entities\Billing\BillingDetails', 'business_profile_id');
	}

}