<?php

namespace Snapfile\Entities\Shared;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('user_id', 'service_profile_id');
	protected $visible = array('user_id', 'service_profile_id');

	public function user()
	{
		return $this->belongsTo('Snapfile\Entities\User\User', 'user_id');
	}

	public function serviceProfile()
	{
		return $this->belongsTo('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
	}

}