<?php

namespace Snapfile\Entities\Shared;

class ClientInvitation extends Eloquent {

	protected $table = 'client_invitations';
	public $timestamps = true;
	protected $fillable = array('service_profile_id', 'existing_user_id', 'created_active_service_id', 'name', 'email', 'status');
	protected $visible = array('service_profile_id', 'existing_user_id', 'created_active_service_id', 'name', 'email', 'status', 'date_of_status_update');

	public function existingUser()
	{
		return $this->belongsTo('Snapfile\Entities\User\User', 'existing_user_id');
	}

	public function senderServiceProfile()
	{
		return $this->belongsTo('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
	}

	public function createdActiveService()
	{
		return $this->belongsTo('Snapfile\Entities\Shared\ActiveService', 'created_active_service_id');
	}

}