<?php

namespace Snapfile\Entities;

class FileReminder extends Eloquent {

	protected $table = 'file_reminders';
	public $timestamps = false;
	protected $fillable = array('file_id', 'date_of_reminder', 'description', 'service_profile_id');
	protected $visible = array('file_id', 'date_of_reminder', 'description', 'service_profile_id');

	public function file()
	{
		return $this->belongsTo('Snapfile\Entities\File', 'file_id');
	}

	public function senderServiceProfile()
	{
		return $this->belongsTo('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
	}

}