<?php

namespace Snapfile\Entities;

class FileShare extends Eloquent {

	protected $table = 'file_shares';
	public $timestamps = true;
	protected $fillable = array('file_id', 'shared_with_user_id', 'shared_with_lead_id', 'shared_with_active_service_id', 'file_request_id');
	protected $visible = array('file_id', 'shared_with_user_id', 'shared_with_lead_id', 'shared_with_active_service_id', 'file_request_id');

	public function file()
	{
		return $this->belongsTo('Snapfile\Entities\File', 'file_id');
	}

	public function user()
	{
		return $this->belongsTo('Snapfile\Entities\User\User', 'shared_with_user_id');
	}

	public function lead()
	{
		return $this->belongsTo('Snapfile\Entities\Shared\Lead', 'shared_with_lead_id');
	}

	public function activeService()
	{
		return $this->belongsTo('Snapfile\Entities\Shared\ActiveService', 'shared_with_active_service_id');
	}

	public function fileRequest()
	{
		return $this->belongsTo('Snapfile\Entities\Shared\FileRequest', 'file_request_id');
	}

}