<?php

namespace Snapfile\Entities\Shared;

class Lead extends Eloquent {

	protected $table = 'leads';
	public $timestamps = true;
	protected $fillable = array('quote_id', 'service_profile_id');
	protected $visible = array('quote_id', 'service_profile_id');

	public function fileShares()
	{
		return $this->hasMany('Snapfile\Entities\FileShare', 'shared_with_lead_id');
	}

	public function quote()
	{
		return $this->belongsTo('Snapfile\Entities\Shared\Quote', 'quote_id');
	}

	public function serviceProfile()
	{
		return $this->belongsTo('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
	}

	public function fileRequests()
	{
		return $this->hasMany('Snapfile\Entities\Shared\FileRequest', 'lead_id');
	}

	public function createdActiveService()
	{
		return $this->hasOne('Snapfile\Entities\Shared\ActiveService', 'approved_lead_id');
	}

}