<?php

namespace Snapfile\Entities\User;

class PersonalFolder extends Eloquent {

	protected $table = 'personal_folder';
	public $timestamps = true;
	protected $fillable = array('name', 'user_id');
	protected $visible = array('name', 'user_id');

	public function user()
	{
		return $this->belongsTo('Snapfile\Entities\User\User', 'user_id');
	}

	public function files()
	{
		return $this->belongsToMany('Snapfile\Entities\File', 'personal_folder_files');
	}

}