<?php

namespace Snapfile\Entities\User;

class Profile extends Eloquent {

	protected $table = 'user_profile';
	public $timestamps = true;
	protected $fillable = array('user_id', 'profile_type_id', 'name');
	protected $visible = array('user_id', 'profile_type_id', 'name');

	public function user()
	{
		return $this->belongsTo('Snapfile\Entities\User\User', 'user_id');
	}

	public function type()
	{
		return $this->belongsTo('ProfileType', 'profile_type_id');
	}

	public function quotes()
	{
		return $this->hasMany('Snapfile\Entities\Shared\Quote', 'quote_id');
	}

	public function activeServices()
	{
		return $this->hasMany('Snapfile\Entities\Shared\ActiveService', 'client_user_profile_id');
	}

}