<?php

namespace Snapfile\Entities;

class ProfileField extends Eloquent {

	protected $table = 'profile_fields';
	public $timestamps = true;
	protected $fillable = array('label', 'type', 'options', 'show_in_leads', 'profile_type_id');
	protected $visible = array('label', 'type', 'options', 'show_in_leads', 'profile_type_id');

	public function profileType()
	{
		return $this->belongsTo('Snapfile\Entities\ProfileType', 'profile_type_id');
	}

	public function serviceTypes()
	{
		return $this->belongsToMany('Snapfile\Entities\ServiceType', 'service_type_profile_fields');
	}

}