<?php

namespace Snapfile\Entities\Shared;

class Quote extends Eloquent {

	protected $table = 'quotes';
	public $timestamps = true;
	protected $fillable = array('user_profile_id', 'service_type_id', 'current_active_service_id');
	protected $visible = array('user_profile_id', 'service_type_id', 'current_active_service_id');

	public function userProfile()
	{
		return $this->belongsTo('Snapfile\Entities\User\Profile', 'user_profile_id');
	}

	public function leads()
	{
		return $this->hasMany('Snapfile\Entities\Shared\Lead', 'quote_id');
	}

	public function activeServiceToBeRemoved()
	{
		return $this->belongsTo('Snapfile\Entities\Shared\ActiveService', 'current_active_service_id');
	}

}