<?php

namespace Snapfile\Entities\Business;

class ServiceProfile extends Eloquent {

	protected $table = 'service_profiles';
	public $timestamps = true;
	protected $fillable = array('business_profile_id', 'service_type_id', 'address_line_1', 'address_line_2', 'address_city', 'address_state', 'address_postcode', 'years_offering_service_for', 'phone_number', 'email');
	protected $visible = array('business_profile_id', 'service_type_id', 'address_line_1', 'address_line_2', 'address_city', 'address_state', 'address_postcode', 'years_offering_service_for', 'phone_number', 'email');

	public function businessProfile()
	{
		return $this->belongsTo('Snapfile\Entities\Business\BusinessProfile', 'business_profile_id');
	}

	public function files()
	{
		return $this->hasMany('Snapfile\Entities\File', 'service_profile_id');
	}

	public function leads()
	{
		return $this->hasMany('Snapfile\Entities\Shared\Lead', 'service_profile_id');
	}

	public function clients()
	{
		return $this->hasMany('Snapfile\Entities\Shared\Client', 'service_profile_id');
	}

	public function clientInvitations()
	{
		return $this->hasMany('Snapfile\Entities\Shared\ClientInvitation', 'service_profile_id');
	}

	public function availableAreas()
	{
		return $this->hasMany('Snapfile\Entities\Business\ServiceProfileArea', 'service_profile_id');
	}

	public function admins()
	{
		return $this->hasMany('Snapfile\Entities\Shared\ServiceAdmin', 'service_profile_id');
	}

	public function notifications()
	{
		return $this->hasMany('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
	}

	public function sentFileReminders()
	{
		return $this->hasMany('Snapfile\Entities\FileReminder', 'service_profile_id');
	}

}