<?php

namespace Snapfile\Entities\Business;

class ServiceProfileArea extends Eloquent {

	protected $table = 'service_profile_area';
	public $timestamps = false;
	protected $fillable = array('service_profile_id', 'type', 'latitude', 'longitude', 'state', 'country', 'subscription_id');
	protected $visible = array('service_profile_id', 'type', 'latitude', 'longitude', 'state', 'country', 'subscription_id');

	public function serviceProfile()
	{
		return $this->belongsTo('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
	}

	public function subscription()
	{
		return $this->belongsTo('Snapfile\Entities\Billing\Subscription', 'subscription_id');
	}

}