<?php

namespace Snapfile\Entities\Billing;

class Subscription extends Eloquent {

	protected $table = 'subscriptions';
	public $timestamps = true;
	protected $fillable = array('billing_details_id', 'plan', 'interval_units', 'interval_type', 'fee_cents', 'next_payment_date');
	protected $visible = array('billing_details_id', 'plan', 'interval_units', 'interval_type', 'fee_cents', 'next_payment_date');

	public function billingDetails()
	{
		return $this->belongsTo('Snapfile\Entities\Billing\BillingDetails', 'billing_details_id');
	}

	public function serviceProfileArea()
	{
		return $this->hasOne('Snapfile\Entities\Business\ServiceProfileArea', 'subscription_id');
	}

	public function billHistory()
	{
		return $this->hasMany('Snapfile\Entities\Billing\Bill', 'subscription_id');
	}

}