<?php

namespace Snapfile\Entities\User;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $guarded = array('remember_token');
	protected $fillable = array('name', 'email', 'password', 'address_line_1', 'address_line_2', 'address_city', 'address_state', 'address_postcode', 'latitude', 'longitude', 'allow_sharing');
	protected $visible = array('address_line_1', 'address_line_2', 'address_city', 'address_state', 'address_postcode', 'latitude', 'longitude', 'allow_sharing');
	protected $hidden = array('remember_token');

	public function folders()
	{
		return $this->hasMany('Snapfile\Entities\User\PersonalFolder', 'user_id');
	}

	public function profiles()
	{
		return $this->hasMany('Snapfile\Entities\User\Profile', 'user_id');
	}

	public function files()
	{
		return $this->hasMany('Snapfile\Entities\File', 'user_id');
	}

	public function fileShares()
	{
		return $this->hasMany('Snapfile\Entities\FileShare', 'shared_with_user_id');
	}

	public function notifications()
	{
		return $this->hasMany('Snapfile\Entities\Notification', 'user_id');
	}

	public function businessProfile()
	{
		return $this->hasOne('Snapfile\Entities\Business\BusinessProfile', 'administrator_user_id');
	}

	public function actingAsClients()
	{
		return $this->hasMany('Snapfile\Entities\Shared\Client', 'user_id');
	}

	public function actingAsServiceAdmins()
	{
		return $this->hasMany('Snapfile\Entities\Shared\ServiceAdmin', 'user_id');
	}

	public function billingDetails()
	{
		return $this->hasOne('Snapfile\Entities\Billing\BillingDetails', 'user_id');
	}

}