<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('service_profile_id')->unsigned();
			$table->enum('type', array('warning', 'error', 'success', 'info'));
			$table->string('message', 2000);
			$table->boolean('has_been_read');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}