<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Procedure extends Eloquent {

	protected $table = 'procedures';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('libelle', 'description', 'submission_form_url', 'dossier_state_url', 'status');

	public function typeProfils()
	{
		return $this->belongsToMany('App\Models\TypeProfil');
	}

	public function favorites()
	{
		return $this->hasMany('App\Models\Favorite');
	}

}