<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Systeme extends Eloquent {

	protected $table = 'systemes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('libelle', 'logo', 'base_url', 'auth_url', 'register_url', 'username', 'password', 'access_token', 'status');

	public function linkedAccounts()
	{
		return $this->hasMany('App\Models\LinkedAccount');
	}

}