<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('email', 'firstname', 'lastname', 'password', 'photo');

	public function typeProfil()
	{
		return $this->belongsTo('App\Models\TypeProfil');
	}

	public function userDetail()
	{
		return $this->hasOne('App\Models\UserDetail');
	}

	public function linkedAccounts()
	{
		return $this->hasMany('App\Models\LinkedAccount');
	}

	public function favorites()
	{
		return $this->hasMany('App\Models\Favorite');
	}

}