<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserDetail extends Eloquent {

	protected $table = 'user_details';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('raison_sociale', 'address', 'nationality', 'date_of_birth', 'groupe_sanguin', 'type_identification', 'numero_identification', 'numero_carte_etudiant', 'ninea', 'numero_permis_conduirre');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

}