<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssignedMilestoneTable extends Migration {

	public function up()
	{
		Schema::create('assigned_milestone', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('house_id');
			$table->integer('assignee_id');
			$table->integer('milestone_id')->nullable();
			$table->string('title');
			$table->text('description');
			$table->integer('milestone_type_id')->nullable();
			$table->timestamp('start_time')->nullable();
			$table->timestamp('end_time')->nullable();
			$table->integer('document_id')->nullable();
			$table->boolean('completed')->default(0);
			$table->timestamp('completed_at')->nullable();
			$table->integer('completed_by')->nullable();
			$table->integer('status')->default('1');
			$table->integer('created_by')->nullable();
			$table->integer('updated_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('assigned_milestone');
	}
}