<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('pocket_id');
			$table->string('currency', 50);
			$table->integer('value');
			$table->boolean('isExpense');
			$table->string('date', 100);
			$table->timestamps();
			$table->string('description', 300);
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}