<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubtransactionsTable extends Migration {

	public function up()
	{
		Schema::create('subtransactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('transaction_id');
			$table->string('description', 300);
			$table->string('value', 200);
			$table->string('currency', 200);
			$table->boolean('isExpense');
			$table->string('date', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('subtransactions');
	}
}