<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('email', 'password', 'name', 'social');

	public function pockets()
	{
		return $this->hasMany('App\Models\Pocket', 'user_id');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification', 'user_id');
	}

	public function transactions()
	{
		return $this->hasMany('App\Models\Transaction', 'user_id');
	}

	public function User_Friend()
	{
		return $this->hasMany('App\Models\UserFriend', 'user_id');
	}

	public function pockets_shared()
	{
		return $this->hasMany('App\Models\PocketShared', 'user_id');
	}

	public function uploads()
	{
		return $this->hasOne('App\Models\Upload', 'user_id');
	}

	public function devices()
	{
		return $this->hasMany('App\Models\UserDevice', 'user_id');
	}

	public function pockets_shared_with()
	{
		return $this->hasOne('App\Models\User', 'user_friend_id');
	}

}