<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('type');

    public function getStores()
    {
        return $this->hasMany('Store');
    }

    public function getFav()
    {
        return $this->hasMany('Favourites');
    }

    public function getWallet()
    {
        return $this->hasOne('Wallet');
    }

    public function getOrders()
    {
        return $this->hasMany('Order');
    }

    public function getMessages()
    {
        return $this->hasMany('Messages');
    }

    public function getRatings()
    {
        return $this->hasMany('Ratings');
    }

    public function getCredits()
    {
        return $this->hasMany('Credit');
    }

}