<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Favourites extends Model 
{

    protected $table = 'favourites';
    public $timestamps = true;
    protected $fillable = array('user_id', 'product_id', 'store_id');

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function getProduct()
    {
        return $this->belongsTo('Products', 'product_id');
    }

    public function getStore()
    {
        return $this->belongsTo('Store', 'store_id');
    }

}