<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Categories extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('title', 'en_title', 'image', 'parent_id');

    public function getAds()
    {
        return $this->hasMany('Ads');
    }

    public function getProducts()
    {
        return $this->hasMany('Products', 'category_id');
    }

    public function getStores()
    {
        return $this->hasMany('Store');
    }

}