<?php

namespace App;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('ar_name', 'en_name', 'ar_descr', 'en_descr', 'discount_value', 'type', 'price', 'qty', 'category_id');

	public function getCategory()
	{
		return $this->belongsTo('Categories', 'category_id');
	}

	public function getImages()
	{
		return $this->hasMany('Images');
	}

	public function getColors()
	{
		return $this->hasMany('Color');
	}

	public function stores()
	{
		return $this->hasMany('Store');
	}

	public function getFav()
	{
		return $this->hasMany('Favourites');
	}

	public function getOrders()
	{
		return $this->hasMany('Order');
	}

	public function getRatings()
	{
		return $this->hasMany('Ratings');
	}

}