<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Ratings extends Model 
{

    protected $table = 'ratings';
    public $timestamps = true;
    protected $fillable = array('degree', 'store_id', 'user_id', 'product_id', 'order_id');

    public function getStore()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function getProduct()
    {
        return $this->belongsTo('Products', 'product_id');
    }

    public function getOrder()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}