<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('user_id', 'color_id', 'qty', 'product_id');

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function getColor()
    {
        return $this->belongsTo('Color');
    }

    public function getRatings()
    {
        return $this->hasMany('Ratings');
    }

}