<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->integer('user_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->string('name', 255);
			$table->string('en_name', 255);
			$table->string('logo', 255);
			$table->string('descr', 255);
			$table->string('en_descr', 255);
			$table->integer('category_id')->unsigned();
			$table->double('lng');
			$table->double('lat');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}