<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->string('name', 255);
			$table->string('designation', 255);
			$table->string('birthday', 100);
			$table->enum('gender', array('male', 'female'));
			$table->text('address');
			$table->string('phone', 50);
			$table->text('social_links');
			$table->tinyInteger('show');
			$table->string('photo', 100);
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}