<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetersTable extends Migration {

	public function up()
	{
		Schema::create('meters', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('consumption_unit_id')->unsigned();
			$table->string('ref_id')->unique()->nullable();
			$table->string('type');
			$table->string('meter_number');
			$table->boolean('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('meters');
	}
}