<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsumptionUnitsTable extends Migration {

	public function up()
	{
		Schema::create('consumption_units', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tenant_id')->unsigned();
			$table->string('ref_id')->nullable();
			$table->text('services')->nullable();
			$table->text('info')->nullable();
			$table->string('street');
			$table->string('number');
			$table->string('unit');
			$table->smallInteger('postalcode')->unsigned();
			$table->string('locality');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('consumption_units');
	}
}