<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerConsumptionUnitTable extends Migration {

	public function up()
	{
		Schema::create('customer_consumption_unit', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('consumption_unit_id')->unsigned();
			$table->timestamp('granted_at');
			$table->timestamp('revoked_at');
			$table->timestamp('expires_at');
			$table->string('downpayment_interval');
			$table->double('downpayment_amount');
			$table->string('downpayment_currency');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_consumption_unit');
	}
}