<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tenant_id')->unsigned();
			$table->string('title')->nullable();
			$table->string('text');
			$table->text('abstract')->nullable();
			$table->datetime('date')->nullable();
			$table->boolean('published');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}